/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatCharMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatCharMap;
import com.gs.collections.api.map.primitive.FloatCharMap;

/**
 * ImmutableFloatCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatCharMapFactoryImpl implements ImmutableFloatCharMapFactory
{
    public ImmutableFloatCharMap of()
    {
        return this.with();
    }

    public ImmutableFloatCharMap with()
    {
        return ImmutableFloatCharEmptyMap.INSTANCE;
    }

    public ImmutableFloatCharMap of(float key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatCharMap with(float key, char value)
    {
        return new ImmutableFloatCharSingletonMap(key, value);
    }

    public ImmutableFloatCharMap ofAll(FloatCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatCharMap withAll(FloatCharMap map)
    {
        if (map instanceof ImmutableFloatCharMap)
        {
            return (ImmutableFloatCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatCharSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatCharHashMap(map);
    }
}
