/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.list.primitive.ImmutableFloatList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableFloatCollection;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseFloatIterable;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveList.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableFloatList
        extends AbstractUnmodifiableFloatCollection
        implements MutableFloatList
{
    private static final long serialVersionUID = 1L;

    UnmodifiableFloatList(MutableFloatList list)
    {
        super(list);
    }

    private MutableFloatList getMutableFloatList()
    {
        return (MutableFloatList) this.getFloatCollection();
    }

    public float get(int index)
    {
        return this.getMutableFloatList().get(index);
    }

    public float getFirst()
    {
        return this.getMutableFloatList().getFirst();
    }

    public float getLast()
    {
        return this.getMutableFloatList().getLast();
    }

    public int indexOf(float value)
    {
        return this.getMutableFloatList().indexOf(value);
    }

    public int lastIndexOf(float value)
    {
        return this.getMutableFloatList().lastIndexOf(value);
    }

    public void addAtIndex(int index, float element)
    {
        throw new UnsupportedOperationException("Cannot call addAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, float... source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public boolean addAllAtIndex(int index, FloatIterable source)
    {
        throw new UnsupportedOperationException("Cannot call addAllAtIndex() on " + this.getClass().getSimpleName());
    }

    public float removeAtIndex(int index)
    {
        throw new UnsupportedOperationException("Cannot call removeAtIndex() on " + this.getClass().getSimpleName());
    }

    public float set(int index, float element)
    {
        throw new UnsupportedOperationException("Cannot call set() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatList with(float element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatList without(float element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatList withAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatList withoutAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableFloatList select(FloatPredicate predicate)
    {
        return this.getMutableFloatList().select(predicate);
    }

    @Override
    public MutableFloatList reject(FloatPredicate predicate)
    {
        return this.getMutableFloatList().reject(predicate);
    }

    @Override
    public <V> MutableList<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.getMutableFloatList().collect(function);
    }

    public MutableFloatList sortThis()
    {
        throw new UnsupportedOperationException("Cannot call sortThis() on " + this.getClass().getSimpleName());
    }

    public double dotProduct(FloatList list)
    {
        return this.getMutableFloatList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        return this.getMutableFloatList().equals(otherList);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableFloatList().hashCode();
    }

    @Override
    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public MutableFloatList asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableFloatList asSynchronized()
    {
        return new SynchronizedFloatList(this);
    }

    @Override
    public ImmutableFloatList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return FloatLists.immutable.with();
        }
        if (size == 1)
        {
            return FloatLists.immutable.with(this.getFirst());
        }
        return FloatLists.immutable.with(this.toArray());
    }

    public MutableFloatList reverseThis()
    {
        throw new UnsupportedOperationException("Cannot call reverseThis() on " + this.getClass().getSimpleName());
    }

    public MutableFloatList toReversed()
    {
        return this.getMutableFloatList().toReversed();
    }

    public void forEachWithIndex(FloatIntProcedure procedure)
    {
        this.getMutableFloatList().forEachWithIndex(procedure);
    }

    public LazyFloatIterable asReversed()
    {
        return ReverseFloatIterable.adapt(this);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableFloatList().injectInto(injectedValue, function);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectFloatIntToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableFloatList().injectIntoWithIndex(injectedValue, function);
    }

    public MutableFloatList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
