/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.configuration;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
public class StringEncryptorConfiguration {
    public static final String ENCRYPTOR_BEAN_PLACEHOLDER = "${jasypt.encryptor.bean:jasyptStringEncryptor}";
    private static final Logger LOG = LoggerFactory.getLogger(StringEncryptorConfiguration.class);

    @Conditional(value={OnMissingEncryptorBean.class})
    @Bean
    public BeanNamePlaceholderRegistryPostProcessor beanNamePlaceholderRegistryPostProcessor(Environment environment) {
        return new BeanNamePlaceholderRegistryPostProcessor(environment);
    }

    @Conditional(value={OnMissingEncryptorBean.class})
    @Bean(name={"${jasypt.encryptor.bean:jasyptStringEncryptor}"})
    public StringEncryptor stringEncryptor(Environment environment) {
        String encryptorBeanName = environment.resolveRequiredPlaceholders(ENCRYPTOR_BEAN_PLACEHOLDER);
        LOG.info("String Encryptor custom Bean not found with name '{}'. Initializing String Encryptor based on properties with name '{}'", (Object)encryptorBeanName, (Object)encryptorBeanName);
        return new LazyStringEncryptor(() -> {
            PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
            SimpleStringPBEConfig config = new SimpleStringPBEConfig();
            config.setPassword(this.getRequiredProperty(environment, "jasypt.encryptor.password"));
            config.setAlgorithm(this.getProperty(environment, "jasypt.encryptor.algorithm", "PBEWithMD5AndDES"));
            config.setKeyObtentionIterations(this.getProperty(environment, "jasypt.encryptor.keyObtentionIterations", "1000"));
            config.setPoolSize(this.getProperty(environment, "jasypt.encryptor.poolSize", "1"));
            config.setProviderName(this.getProperty(environment, "jasypt.encryptor.providerName", "SunJCE"));
            config.setSaltGeneratorClassName(this.getProperty(environment, "jasypt.encryptor.saltGeneratorClassname", "org.jasypt.salt.RandomSaltGenerator"));
            config.setStringOutputType(this.getProperty(environment, "jasypt.encryptor.stringOutputType", "base64"));
            encryptor.setConfig((PBEConfig)config);
            return encryptor;
        });
    }

    private String getProperty(Environment environment, String key, String defaultValue) {
        if (!this.propertyExists(environment, key)) {
            LOG.info("Encryptor config not found for property {}, using default value: {}", (Object)key, (Object)defaultValue);
        }
        return environment.getProperty(key, defaultValue);
    }

    private boolean propertyExists(Environment environment, String key) {
        return environment.getProperty(key) != null;
    }

    private String getRequiredProperty(Environment environment, String key) {
        if (!this.propertyExists(environment, key)) {
            throw new IllegalStateException(String.format("Required Encryption configuration property missing: %s", key));
        }
        return environment.getProperty(key);
    }

    private static final class SingletonSupplier<T>
    implements Supplier<T> {
        private boolean initialized = false;
        private volatile Supplier<T> instanceSupplier = () -> {
            Supplier supplier2 = original;
            synchronized (supplier2) {
                if (!this.initialized) {
                    Object singletonInstance = original.get();
                    this.instanceSupplier = () -> singletonInstance;
                    this.initialized = true;
                }
                return this.instanceSupplier.get();
            }
        };

        private SingletonSupplier(Supplier<T> original) {
        }

        @Override
        public T get() {
            return this.instanceSupplier.get();
        }
    }

    private static final class LazyStringEncryptor
    implements StringEncryptor {
        private final Supplier<StringEncryptor> supplier;

        private LazyStringEncryptor(Supplier<StringEncryptor> encryptorFactory) {
            this.supplier = new SingletonSupplier<StringEncryptor>(encryptorFactory);
        }

        public String encrypt(String message) {
            return this.supplier.get().encrypt(message);
        }

        public String decrypt(String encryptedMessage) {
            return this.supplier.get().decrypt(encryptedMessage);
        }
    }

    private static class BeanNamePlaceholderRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor,
    Ordered {
        private Environment environment;

        private BeanNamePlaceholderRegistryPostProcessor(Environment environment) {
            this.environment = environment;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            DefaultListableBeanFactory bf = (DefaultListableBeanFactory)registry;
            Stream.of(bf.getBeanDefinitionNames()).filter(name -> name.matches("\\$\\{[\\w\\.-]+(?>:[\\w\\.-]+)?\\}")).forEach(placeholder -> {
                String actualName = this.environment.resolveRequiredPlaceholders(placeholder);
                BeanDefinition bd = bf.getBeanDefinition(placeholder);
                bf.removeBeanDefinition(placeholder);
                bf.registerBeanDefinition(actualName, bd);
                LOG.debug("Registering new name '{}' for Bean definition with placeholder name: {}", (Object)actualName, placeholder);
            });
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public int getOrder() {
            return 0x7FFFFFFE;
        }
    }

    private static class OnMissingEncryptorBean
    implements ConfigurationCondition {
        private OnMissingEncryptorBean() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !context.getBeanFactory().containsBean(context.getEnvironment().resolveRequiredPlaceholders(StringEncryptorConfiguration.ENCRYPTOR_BEAN_PLACEHOLDER));
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }
}

