/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.clause;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.dialect.mysql.MySQLKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Keyword;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.TableReferencesClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLStatement;

public final class MySQLTableReferencesClauseParser
extends TableReferencesClauseParser {
    public MySQLTableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
    }

    @Override
    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
        this.parsePartition();
        this.parseIndexHint(sqlStatement);
    }

    private void parsePartition() {
        this.getLexerEngine().unsupportedIfEqual(MySQLKeyword.PARTITION);
    }

    private void parseIndexHint(SQLStatement sqlStatement) {
        if (this.getLexerEngine().skipIfEqual(DefaultKeyword.USE, MySQLKeyword.IGNORE, MySQLKeyword.FORCE)) {
            this.getLexerEngine().skipAll(DefaultKeyword.INDEX, DefaultKeyword.KEY, DefaultKeyword.FOR, DefaultKeyword.JOIN, DefaultKeyword.ORDER, DefaultKeyword.GROUP, DefaultKeyword.BY);
            this.getLexerEngine().skipParentheses(sqlStatement);
        }
    }

    @Override
    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[]{MySQLKeyword.STRAIGHT_JOIN};
    }
}

