/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.clause;

import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.ExpressionClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.SQLClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.DMLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.TableToken;
import com.dangdang.ddframe.rdb.sharding.util.SQLUtil;

public final class UpdateSetItemsClauseParser
implements SQLClauseParser {
    private final LexerEngine lexerEngine;
    private final ExpressionClauseParser expressionClauseParser;

    public UpdateSetItemsClauseParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.expressionClauseParser = new ExpressionClauseParser(lexerEngine);
    }

    public void parse(DMLStatement updateStatement) {
        this.lexerEngine.accept(DefaultKeyword.SET);
        do {
            this.parseSetItem(updateStatement);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    private void parseSetItem(DMLStatement updateStatement) {
        this.parseSetColumn(updateStatement);
        this.lexerEngine.skipIfEqual(Symbol.EQ, Symbol.COLON_EQ);
        this.parseSetValue(updateStatement);
    }

    private void parseSetColumn(DMLStatement updateStatement) {
        if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
            this.lexerEngine.skipParentheses(updateStatement);
            return;
        }
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            if (updateStatement.getTables().getSingleTableName().equalsIgnoreCase(SQLUtil.getExactlyValue(literals))) {
                updateStatement.getSqlTokens().add(new TableToken(beginPosition - literals.length(), literals));
            }
            this.lexerEngine.nextToken();
        }
    }

    private void parseSetValue(DMLStatement updateStatement) {
        this.expressionClauseParser.parse(updateStatement);
    }
}

