package com.daas.nros.openapi.client.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class VGStoreListRequestVO {

    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotBlank(message ="品牌编号不能为空" )
    private String brandCode;
    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotBlank(message ="纬度不能为空" )
    private String lat;
    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotBlank(message ="精度不能为空" )
    private String lng;
    @ApiModelProperty(value = "", name = "pageNum", notes = "分页页码")
    @NotNull(message = "分页页码不能为空")
    private Integer pageNum;
    @ApiModelProperty(value = "", name = "pageSize", notes = "分页大小")
    @NotNull(message = "分页大小不能为空")
    private Integer pageSize;
    @ApiModelProperty(value = "", name = "brandCode", notes = "查询门店值")
    private String storeName;
    @ApiModelProperty(value = "", name = "couponId", notes = "券id")
    private String couponEntityId;
    @ApiModelProperty(value = "", name = "sysCompanyId", notes = "集团id")
    private Long sysCompanyId;

}
