package com.daas.nros.openapi.client.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class VGOrderDetailListRequestVO {
    @ApiModelProperty(value = "", name = "cardNo", notes = "会员卡号")
    @NotBlank(message ="会员卡号不能为空" )
    private String cardNo;
    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotBlank(message ="品牌编号不能为空" )
    private String brandCode;
    @ApiModelProperty(value = "", name = "orderStatus", notes = "订单状态")
    private Integer orderStatus;
    @ApiModelProperty(value = "", name = "orderFrom", notes = "订单来源")
    private Integer orderFrom;
    @ApiModelProperty(value = "", name = "startTime", notes = "查询下单时间开始")
    private String orderTimeStart;
    @ApiModelProperty(value = "", name = "endTime", notes = "查询下单时间结束")
    private String orderTimeEnd;
    @ApiModelProperty(value = "", name = "pageNum", notes = "分页页码")
    @NotNull(message = "分页页码不能为空")
    private Integer pageNum;
    @ApiModelProperty(value = "", name = "pageSize", notes = "分页大小")
    @NotNull(message = "分页大小不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "", name = "sysCompanyId", notes = "集团id")
    private Long sysCompanyId;


}
