package com.daas.nros.openapi.client.utils;

import com.daas.nros.openapi.client.model.vo.CommonGoodsSkuApiInfo;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;

public class JsonValidUtil {

    public static Boolean isContainsKey(List<CommonGoodsSkuApiInfo> list) {
        Boolean bol=false;
        if(null == list || list.size() ==0 ){
            return bol;
        }else{
            for (Iterator<CommonGoodsSkuApiInfo> iterator = list.iterator(); iterator.hasNext(); ) {
                CommonGoodsSkuApiInfo commonGoodsSkuApiInfo =  iterator.next();
                if (checkObjFieldsIsNull(commonGoodsSkuApiInfo)) {
                    bol=true;
                    break;
                }
            }
        }
        return bol;
    }
    /**
     * 判断对象中属性值是否为空
     *
     * @param commonGoodsSkuApiInfo
     * @return
     */
    public static boolean checkObjFieldsIsNull(CommonGoodsSkuApiInfo commonGoodsSkuApiInfo) {
        if (null == commonGoodsSkuApiInfo) {
            return true;
        }
        try {
            for (Field f : commonGoodsSkuApiInfo.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (f.get(commonGoodsSkuApiInfo) == null|| StringUtils.isBlank(f.get(commonGoodsSkuApiInfo).toString())) {
                    return true;
                }
            }
        } catch (Exception e) {
        }
        return false;
    }

}
