package com.daas.nros.openapi.client.utils;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;

import java.io.UnsupportedEncodingException;
import java.util.Base64;

@Slf4j
public class JinHongUtil {

    /**
     * 生成签名
     * @param appId     应用id
     * @param appSecret secret
     * @param version   版本号
     * @param method    方法
     * @param timestamp 时间戳
     * @return  生成签名
     */
    public static String checkSign(String appId, String appSecret, String version, String method, String timestamp) {
        StringBuffer buff = new StringBuffer();
        try {
            String appIdBase64 = new String(Base64.getEncoder().encode(appId.getBytes("UTF-8")));
            String appSecretBase64 = new String(Base64.getEncoder().encode(appSecret.getBytes("UTF-8")));
            String versionBase64 = new String(Base64.getEncoder().encode(version.getBytes("UTF-8")));
            String methodBase64 = new String(Base64.getEncoder().encode(method.getBytes("UTF-8")));
            String timestampBase64 = new String(Base64.getEncoder().encode(timestamp.getBytes("UTF-8")));

            JSONObject signParam = new JSONObject();
            signParam.put("appId",appIdBase64);
            signParam.put("appSecret",appSecretBase64);
            signParam.put("version",versionBase64);
            signParam.put("method",methodBase64);
            signParam.put("timestamp",timestampBase64);
            log.info("signParam:{}",signParam.toJSONString());

            // 依次按照appId、appSecret、version、method、timestamp顺序拼接
            buff.append("appId=").append(appIdBase64);
            buff.append("&appSecret=").append(appSecretBase64);
            buff.append("&version=").append(versionBase64);
            buff.append("&method=").append(methodBase64);
            buff.append("&timestamp=").append(timestampBase64);
            byte[] encode = Base64.getEncoder().encode(buff.toString().getBytes("UTF-8"));
            log.info("加密前：{}",buff.toString());
            String md5Digest = org.apache.commons.codec.digest.DigestUtils.md5Hex(encode).toUpperCase();
            log.info("加密后：{}",md5Digest);
            return md5Digest;
        } catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), e);
        }
        return "";
    }
}
