package com.daas.nros.openapi.client.model.vo.webhook;

import com.daas.nros.openapi.client.annotation.EnumStringValue;
import com.daas.nros.openapi.client.enums.StringBrandCode;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class AddInviteTaskVo {

    //品牌code
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    /**
     * 邀约任务名称
     */
    @NotEmpty
    private String taskName;

    /**
     * 任务开始时间
     */
    private Date taskStartDate;

    /**
     * 任务结束时间
     */
    @NotNull
    private Date taskEndDate;

    /**
     * 邀约话术
     */
    private String script;

    /**
     * 邀约说明
     */
    private String inviteExplain;

}
