package com.daas.nros.openapi.client.model.vo;

import com.daas.nros.openapi.client.annotation.EnumStringValue;
import com.daas.nros.openapi.client.enums.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class VgMemberQueryRequestVo {
	@NotBlank(message = "品牌code不能为空")
	@EnumStringValue(StringBrandCode.class)
	private String brandCode;

	private String phone;

	private String cardNo;

	private String wxUnionId;

	private String userId;

	@Override
	public String toString() {
		return "VgMemberQueryRequestVo{" +
				"brandCode='" + brandCode + '\'' +
				", phone='" + phone + '\'' +
				", cardNo='" + cardNo + '\'' +
				", wxUnionId='" + wxUnionId + '\'' +
				", userId='" + userId + '\'' +
				'}';
	}
}
