package com.daas.nros.openapi.client.model.vo;


import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lijiachun
 * @version 0.0.1
 * @since 0.0.1 2020-02-24
 */
@Data
@Builder
public class CouponEntityApiVO implements Serializable {

    /**
     * 券code
     */
    private  String couponCode;
    /**
     * 券名称
     */
    private  String couponName;
    /**
     * 券类型 1现金，2折扣，3礼品
     */
    private  Byte couponType;
    /**
     *  券面额
     */
    private BigDecimal  money;
    /**
     *  券折扣
     */
    private BigDecimal discount;
    /**
     * 有效期开始时间
     */
    private Date validDateStart;
    /**
     * 有效期结束时间
     */
    private Date validDateEnd;
}
