package com.daas.nros.openapi.client.model.vo;

import com.bizvane.members.facade.vo.CommonOrderRequestVo;
import lombok.Data;

import java.util.Objects;

/**
 * @Author sampson
 * @Date 2021-03-31 19:30
 * @Describe
 */
@Data
public class CommonOrderFailRequestApiVo extends CommonOrderRequestVo {

    /**
     * 初始次数
     */
    private int initRetryNum = 0;

    /**
     * 最大重试次数
     */
    private int maxRetryNum = 3;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonOrderFailRequestApiVo that = (CommonOrderFailRequestApiVo) o;
        return getSysCompanyId().equals(that.getSysCompanyId()) && getBrandCode().equals(that.getBrandCode()) && getOrderNo().equals(that.getOrderNo());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getSysCompanyId()) & Objects.hash(getBrandCode()) & Objects.hash(getOrderNo());
    }

}
