package com.daas.nros.openapi.client.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Objects;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CommonOrderApiDetail {

    private Long sysCompanyId; //  企业ID

    private String orderNo ; // 订单No

    private String productBrandCode;//	是	string	商品品牌code

    private String orderDetailNo;//	否	string	订单明细单号

    private Integer quantity;//	否	int	购买数量

    private String productNo;//	否	string	商品编号(spuCode)

    private String productItemId ; // 条码

    private String productName;//	否	string	商品名称(spuName)

    private String skuCode;//	否	string	skuCode

    private BigDecimal tagPrice;//	否	decimal	商品吊牌价

    private BigDecimal tradeAmountDetail;//	否	decimal	成交单价(商品吊牌价x商品折扣率)

    private BigDecimal discountPrice;//	否	decimal	折扣价

    private BigDecimal rebate;//	否	int	商品折扣率（折扣价/吊牌价）

    private String specification;//	否	string	规格（商品样式）

    private String color;//	否	string	颜色

    private String size;//	否	string	大小

    private String productGuideCode;//	否	string	商品导购code

    private String serviceGuideProportion;//导购比例

    private String offlineProductGuideCode ; // 商品导购线下code

    private String productGuideName ; // 商品导购name

    private String sku ; //

    private String serviceGuideIds; // 订单服务导购ids，以逗号分隔

    private Integer integralUsed; // 使用积分数量

    private Integer integralSend; // 赠送积分数量

    private BigDecimal activityPrice;

    private Long activityId ;

    private Integer activity;

    /**
     * 新增字段,拼接一个俱乐部code和商品code
     */
    private String offlineProductCode;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonOrderApiDetail that = (CommonOrderApiDetail) o;
        return sysCompanyId.equals(that.sysCompanyId) && productBrandCode.equals(that.productBrandCode) && orderNo.equals(that.orderNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sysCompanyId)&Objects.hash(productBrandCode)&Objects.hash(orderNo);
    }

}
