package com.daas.nros.openapi.client.enums;


public enum GoodsSpecificationType {

    COLOR("COLOR", "颜色"),
    SIZE("SIZE", "尺码");

    String code;
    String desc;

    GoodsSpecificationType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getGoodsSpecDescByCode(String code){
        for(GoodsSpecificationType specType : GoodsSpecificationType.values()){
            if(code.equals(specType.getCode())){
                return specType.getDesc();
            }
        }
        return null;
    }

}
