package com.daas.nros.openapi.client.annotation;

import com.daas.nros.openapi.client.valid.DateValidate;
import com.daas.nros.openapi.client.constant.ValidConstants;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = DateValidate.class)
public @interface DateStyle {
    String message() default ValidConstants.DATE_ERROR_MESSAGE;

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
