/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.openapi.utils.valid;

import com.daas.nros.openapi.utils.valid.EnumStringValue;
import java.lang.reflect.Method;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumValueStringValidator
implements ConstraintValidator<EnumStringValue, String> {
    private Class<? extends Enum> enumClass;
    private static final String METHOD_NAME = "toEnum";

    public void initialize(EnumStringValue constraintAnnotation) {
        this.enumClass = constraintAnnotation.value();
        try {
            this.enumClass.getDeclaredMethod(METHOD_NAME, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("the enum class has not toEnum method", e);
        }
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        Method declareMethod;
        try {
            declareMethod = this.enumClass.getDeclaredMethod(METHOD_NAME, String.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        try {
            declareMethod.invoke(null, value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

