/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.openapi.utils;

import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.UUID;

public class StringUtil {
    private static final int INT0X4E00 = 19968;
    private static final int INT0X9FA5 = 40869;
    private static final int INT0XF900 = 63744;
    private static final int INT0XFA2D = 64045;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String WLBM_REGEX = "[1-9]";
    private static final String WLBM_ZERO_1 = "0";

    public static boolean availableStr(String str) {
        return str != null && !"".equals(str) && !"null".equals(str);
    }

    public static String getSubString(String str, int len) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        if (0 >= len) {
            return str;
        }
        int byteLength = StringUtil.getByteLength(str);
        if (byteLength < len) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        sb.setLength(len);
        while (StringUtil.getByteLength(sb.toString()) > len) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean isInteger(String str) {
        if (StringUtil.availableStr(str)) {
            try {
                Integer.parseInt(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLong(String str) {
        if (StringUtil.availableStr(str)) {
            try {
                Long.parseLong(str);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static int getByteLength(String str) {
        int len = 0;
        if (StringUtil.isEmpty(str)) {
            return len;
        }
        try {
            len = str.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return len;
    }

    public static int getByteLengthByGBK(String str) {
        int len = 0;
        if (StringUtil.isEmpty(str)) {
            return len;
        }
        try {
            len = str.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return len;
    }

    public static boolean isEmpty(String str) {
        return null == str || 0 == str.length() || "null".equals(str) || "".equals(str);
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0 && !"null".equalsIgnoreCase(str);
    }

    public static boolean isNullOrEmpty(String str) {
        return null == str || "".equals(str);
    }

    public static String escapeSpecialChar(String inStr) {
        if (null == inStr || "null".equals(inStr) || "".equals(inStr)) {
            return "";
        }
        String outStr = "";
        String srcStr1 = "\"";
        String destStr1 = "\\\\\"";
        String srcStr2 = "\\\\";
        String destStr2 = "\\\\\\\\";
        outStr = inStr.replaceAll(srcStr2, destStr2);
        outStr = outStr.replaceAll(srcStr1, destStr1);
        return outStr;
    }

    public static String encodeExcelXmlStr(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("\r\n", "&#10;").replaceAll("\n", "&#10;");
    }

    public static String formatCurrency(double number) {
        NumberFormat formater = NumberFormat.getCurrencyInstance();
        return formater.format(number);
    }

    public static String nvl(String str) {
        if (StringUtil.isEmpty(str)) {
            return "";
        }
        return str.trim();
    }

    public static String fir2Upper(String property) {
        String firChar = property.substring(0, 1);
        String upperChar = firChar.toUpperCase();
        String res = upperChar + property.substring(1);
        return res;
    }

    public static boolean isChineseWithoutPunctuation(char oneChar) {
        return oneChar >= '\u4e00' && oneChar <= '\u9fa5' || oneChar >= '\uf900' && oneChar <= '\ufa2d';
    }

    public static boolean isChineseWithPunctuation(char oneChar) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(oneChar);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static String toUnicode(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x != 0 && !escapeSpace) continue block8;
                    outBuffer.append('\\');
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(StringUtil.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(StringUtil.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(StringUtil.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(StringUtil.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String checkNullValueAndTrim(String value) {
        return null == value ? "" : value.trim();
    }

    public static long checkNullValueAndParseLong(String value) {
        if (null != value && !"".equals(value.trim())) {
            return Long.parseLong(value.trim());
        }
        return 0L;
    }

    public static Double checkNullValueAndParseDouble(String value) {
        if (null != value && !"".equals(value.trim())) {
            return Double.parseDouble(value.trim());
        }
        return 0.0;
    }

    public static Integer checkNullValueAndParseInteger(String value) {
        if (null != value && !"".equals(value.trim())) {
            return Integer.parseInt(value.trim());
        }
        return 0;
    }

    public String fileUpload() {
        String path = this.getClass().getClassLoader().getResource("/").getPath();
        path = path.substring(path.indexOf("WebContent"));
        return path;
    }

    public static String toInCondition(String[] arr) {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < arr.length; ++index) {
            if (index == 0) {
                buffer.append("'").append(arr[index]).append("'");
                continue;
            }
            buffer.append(",'").append(arr[index]).append("'");
        }
        return buffer.toString();
    }

    public static String toInCondition(String[] arr, boolean twoQuote, boolean iswlbm) {
        String quote = "'";
        if (twoQuote) {
            quote = "''";
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < arr.length; ++index) {
            String value = arr[index];
            if (iswlbm) {
                value = StringUtil.fmtLongWlbm(value);
            }
            if (index == 0) {
                buffer.append(quote).append(value).append(quote);
                continue;
            }
            buffer.append(",").append(quote).append(value).append(quote);
        }
        return buffer.toString();
    }

    public static String fmtLongWlbm(String shortwlBm) {
        String startStr;
        String retVal = shortwlBm;
        if (StringUtil.isNotEmpty(shortwlBm) && (startStr = shortwlBm.substring(0, 1)).matches(WLBM_REGEX)) {
            while (retVal.length() < 18) {
                retVal = WLBM_ZERO_1 + retVal;
            }
        }
        return retVal;
    }

    public static String fmtShortDate(String yyyy_mm_dd) {
        if (StringUtil.isNotEmpty(yyyy_mm_dd)) {
            return yyyy_mm_dd.replace("-", "");
        }
        return yyyy_mm_dd;
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        String uuidStr = uuid.toString().replace("-", "");
        return uuidStr;
    }
}

