/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.openapi.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Sum {
    private MessageDigest md;
    private long length;
    private InputStream input;
    private String checksum;
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public MD5Sum() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void setInputStream(InputStream stream) {
        this.input = stream;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimal[high];
            buffer[i * 2 + 1] = hexadecimal[low];
        }
        return new String(buffer);
    }

    public byte[] getBytes(File file) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream stream = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = ((InputStream)stream).read(buf, 0, 1024)) != -1) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("getBytes(file)\u5f02\u5e38", e);
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public void execute() throws IOException {
        this.readInputStream();
        this.setChecksum(this.encode(this.md.digest()));
    }

    private void update(byte[] buffer, int offset, int len) {
        this.md.update(buffer, offset, len);
        this.length += (long)len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInputStream() throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(this.input);
            this.reset();
            int len = 0;
            byte[] buffer = new byte[8192];
            while ((len = bis.read(buffer)) > -1) {
                this.update(buffer, 0, len);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void reset() {
        this.md.reset();
        this.length = 0L;
    }

    public static String toCheckSumStr(String str) throws IOException {
        MD5Sum sum = new MD5Sum();
        sum.setInputStream(new ByteArrayInputStream(str.getBytes("UTF-8")));
        sum.execute();
        return sum.getChecksum();
    }

    public static String toCheckSum(InputStream fileStream) throws IOException {
        MD5Sum sum = new MD5Sum();
        sum.setInputStream(fileStream);
        sum.execute();
        return sum.getChecksum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toCheckSum(String file) throws IOException {
        MD5Sum sum = new MD5Sum();
        FileInputStream fileStream = new FileInputStream(file);
        try {
            sum.setInputStream(fileStream);
            sum.execute();
            String string = sum.getChecksum();
            return string;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getSign(String ts, String userId, String skey) {
        String sign = null;
        try {
            new MD5Sum();
            sign = MD5Sum.toCheckSumStr(userId + ts + skey);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sign;
    }

    public static byte[] getMD5Byte16(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public static String getMD5Str32(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        byte[] md5Byte16 = MD5Sum.getMD5Byte16(str);
        if (md5Byte16 == null || md5Byte16.length == 0) {
            return null;
        }
        return MD5Sum.byteToHexString(md5Byte16);
    }

    public static String byteToHexString(byte[] tmp) {
        char[] str = new char[32];
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            byte byte0 = tmp[i];
            str[k++] = hexadecimal[byte0 >>> 4 & 0xF];
            str[k++] = hexadecimal[byte0 & 0xF];
        }
        String s = new String(str);
        return s;
    }
}

