package com.daas.nros.openapi.utils.valid;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;

public class EnumValueStringValidator implements ConstraintValidator<EnumStringValue, String> {

    private Class<? extends Enum> enumClass;
    private static final String METHOD_NAME = "toEnum";

    //这个方法做一些初始化校验
    @Override
    public void initialize(EnumStringValue constraintAnnotation) {
        enumClass = constraintAnnotation.value();
        try {
            // 先判断该enum是否实现了toEnum方法
            enumClass.getDeclaredMethod(METHOD_NAME, String.class);
        } catch (NoSuchMethodException e){
            throw new IllegalArgumentException("the enum class has not toEnum method", e);
        }
    }

    // 这个方法写具体的校验逻辑：校验数字是否属于指定枚举类型的范围
    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        Method declareMethod;
        try {
            declareMethod = enumClass.getDeclaredMethod(METHOD_NAME, String.class);
        } catch (NoSuchMethodException e) {
            return false;
        }
        try {
            declareMethod.invoke(null, value);
        } catch (Exception e) {
            return false;
        }
        return true;
    }

}
