package com.daas.nros.openapi.utils;

import com.bizvane.utils.responseinfo.ResponseData;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.*;

/**
 *
 * @author bizvane
 * @date 2020/07/25
 */
public class ValidateUtils {
    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public ValidateUtils() {
    }

    public static <T> List<String> validate(T t) {
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<T>> constraintViolations = validator.validate(t, new Class[0]);
        List<String> messageList = new ArrayList();
        Iterator var4 = constraintViolations.iterator();

        while(var4.hasNext()) {
            ConstraintViolation<T> constraintViolation = (ConstraintViolation)var4.next();
            messageList.add(constraintViolation.getMessage());
        }

        return messageList;
    }

    public static <T> ResponseData validateAndAdvice(T t) {
        if (t == null) {
            return ResponseUtil.getFailedData(("param can't be null!"),null);
        } else {
            List<String> validateList = validate(t);
            if (validateList != null && !validateList.isEmpty()) {
                Set<String> set = new HashSet(validateList);
                validateList = new ArrayList(set);
                StringBuilder sb = new StringBuilder();
                Iterator var4 = validateList.iterator();

                while(var4.hasNext()) {
                    String message = (String)var4.next();
                    sb.append(message + " ");
                }
                return ResponseUtil.getFailedData(sb.toString(),null);
            } else {
                return null;
            }
        }
    }

    public static <T> ResponseData validate(T object, String msg, Class... groups) {
        if (object == null) {
            return ResponseUtil.getFailedData(msg,null);
        } else {
            Set<ConstraintViolation<T>> validator = factory.getValidator().validate(object, groups);
            return validator != null && validator.iterator().hasNext() ? ResponseUtil.getFailedData(((ConstraintViolation)validator.iterator().next()).getMessage(),null) : null;
        }
    }

}
