package com.daas.nros.openapi.utils;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;


public class ResponseUtil {

	private static final ThreadLocal <ResponseData> threadLocal = new ThreadLocal <ResponseData>();

	/**
	 * 获取相应数据对象
	 *
	 * @return
	 */
	public static ResponseData getResponseData() {
		ResponseData responseData = threadLocal.get();
		if (responseData == null) {
			responseData = new ResponseData();
			threadLocal.set(responseData);
		}
		return responseData;
	}

	/**
	 * 获取成功响应
	 *
	 * @param data
	 * @return
	 */
	public static ResponseData getSuccessData(Object data) {
		ResponseData responseData = getResponseData();
		responseData.setCode(SysResponseEnum.SUCCESS.getCode());
		responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
		responseData.setData(data);
		return responseData;
	}

	public static ResponseData getSuccessData(Object data, String msg) {
		ResponseData responseData = getResponseData();
		responseData.setCode(SysResponseEnum.SUCCESS.getCode());
		responseData.setMessage(msg);
		responseData.setData(data);
		return responseData;
	}

	/**
	 * 获取失败响应信息
	 *
	 * @param data
	 * @return
	 */
	public static ResponseData getFailedData(Object data) {
		ResponseData responseData = getResponseData();
		responseData.setCode(SysResponseEnum.FAILED.getCode());
		responseData.setMessage(SysResponseEnum.FAILED.getMessage());
		responseData.setData(data);
		return responseData;
	}

	public static ResponseData getFailedData(Object data, String msg) {
		ResponseData responseData = getResponseData();
		responseData.setCode(SysResponseEnum.FAILED.getCode());
		responseData.setMessage(msg);
		responseData.setData(data);
		return responseData;
	}

	/**
	 * 返回失败响应信息，支持泛型
	 * @param t
	 * @param <T>
	 * @return
	 */
	public static <T>ResponseData<T> getFailedResponse(T t){
		return new ResponseData<>(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), t);
	}

	/**
	 * 返回失败响应信息，支持泛型
	 * @param <T>
	 * @return
	 */
	public static <T>ResponseData<T> getFailedResponse(){
		return getFailedResponse(null);
	}

	/**
	 * 返回失败响应信息，支持泛型
	 * @param message
	 * @param <T>
	 * @return
	 */
	public static <T>ResponseData<T> getFailedResponse(String message){
		return new ResponseData<>(SysResponseEnum.FAILED.getCode(), message, null);
	}

	public static ResponseData error(SysResponseEnum senum){
		ResponseData responseData = new ResponseData();
		responseData.setCode(senum.getCode());
		responseData.setMessage(senum.getMessage());
		return responseData;
	}

	public static ResponseData error(String message){
		ResponseData responseData = new ResponseData();
		responseData.setCode(SysResponseEnum.FAILED.getCode());
		responseData.setMessage(message);
		return responseData;
	}

	public static ResponseData<String> error(BizException e){
		ResponseData<String> responseData = new ResponseData<>();
		responseData.setCode(e.getCode());
		responseData.setMessage(e.getMessage());
		responseData.setData(e.getData());
		return responseData;
	}

	public static ResponseData success(){
		return new ResponseData();
	}

	public static ResponseData success(Object o){
		return new ResponseData<>(o);
	}
}
