package com.daas.nros.openapi.utils;
/*
 * Created by JiangWenjian on 2019-10-16.
 */

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;

/**
 * @author jiangwenjian
 * @version 0.0.1
 * @since 0.0.1 2019-10-16
 */
public class HeadUtil {

    private static final Logger logger = LoggerFactory.getLogger(HeadUtil.class);

    /**
     * 忽略大小写获取head中的信息
     *
     * @param request
     * @return
     */
    public static HashMap<String, String> getHeaderInfo(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = request.getHeader(key);
            String keymap = key.toLowerCase();
            map.put(keymap, value);
        }
        return map;
    }

    /**
     * 获取开放平台传的
     *
     * @param request
     * @return
     */
    public static Long getCorpId(HttpServletRequest request) {
        HashMap<String, String> head = getHeaderInfo(request);
        Long corpId = null;
        try {
            String corpIdString=head.get("bizvane-request-business-id");
            if(StringUtil.isEmpty(corpIdString)||"null".equals(corpIdString)||"".equals(corpIdString)){
             corpIdString=head.get("bizvane-reuqest-business-id");
            }
            corpId = Long.parseLong(corpIdString);
        } catch (Exception e) {
            logger.info("获取开放平台企业ID错误:{}", e.getMessage());
        }
        return corpId;
    }

    public static String getCorpCode(HttpServletRequest request) {
        HashMap<String, String> head = getHeaderInfo(request);
        String corpCode = null;
        try {
            corpCode = head.get("bizvane-request-business-id");
        } catch (Exception e) {
            logger.info("获取开放平台企业ID错误:{}", e.getMessage());
        }
        return corpCode;
    }

    /**
     * 获取webhook传参X-QA-Hmac-Signature用以鉴权
     * @param request
     * @return
     */
    public static String getQaHmacSignature(HttpServletRequest request) {
        HashMap<String, String> head = getHeaderInfo(request);
        String signature=head.get("X-QA-Hmac-Signature");
        logger.info("getQaHmacSignature:{}", signature);
        return signature;
    }
}
