package com.daas.nros.openapi.utils;


import com.daas.nros.openapi.constant.BandConstants;
import com.daas.nros.openapi.enums.ChannelEnum;
import com.daas.nros.openapi.enums.OpenCardActionEnum;
import com.daas.nros.openapi.enums.OrderActionEnum;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Common361Util {

    public static Map<String, Integer> createSelectChannel(String brandCode) {
        Map<String, Integer> map = new LinkedHashMap<>();
        switch (brandCode) {
            case BandConstants.C361LIST:
                map.put(BandConstants.C361DZ, ChannelEnum.OPENAPI_ONLINE_OFFLINE.getCode());
                map.put(BandConstants.C361ET, ChannelEnum.PLATFORM_ONLINE.getCode());
                map.put(BandConstants.C361CQ, ChannelEnum.PLATFORM_ONLINE.getCode());
                break;
            case BandConstants.C361DZ:
                map.put(BandConstants.C361DZ, ChannelEnum.OPENAPI_ONLINE_OFFLINE.getCode());
                map.put(BandConstants.C361ET, ChannelEnum.PLATFORM_ONLINE.getCode());
                map.put(BandConstants.C361CQ, ChannelEnum.PLATFORM_ONLINE.getCode());
                break;
            case BandConstants.C361ET:
                map.put(BandConstants.C361ET, ChannelEnum.OPENAPI_ONLINE_OFFLINE.getCode());
                map.put(BandConstants.C361DZ, ChannelEnum.PLATFORM_ONLINE.getCode());
                map.put(BandConstants.C361CQ, ChannelEnum.PLATFORM_ONLINE.getCode());
                break;
            case BandConstants.C361CQ:
                map.put(BandConstants.C361CQ, ChannelEnum.OPENAPI_ONLINE_OFFLINE.getCode());
                map.put(BandConstants.C361DZ, ChannelEnum.PLATFORM_ONLINE.getCode());
                map.put(BandConstants.C361ET, ChannelEnum.PLATFORM_ONLINE.getCode());
                break;
        }
        return map;
    }

    /**
     * 根据传入brandCode判断返回数据应该是对应的哪个品牌
     *
     * @param brandCode
     * @return
     */
    public static String returnPrimaryChannel(String brandCode) {
        switch (brandCode) {
            case BandConstants.C361LIST:
                return BandConstants.C361DZ;
            case BandConstants.C361DZ:
                return BandConstants.C361DZ;
            case BandConstants.C361ET:
                return BandConstants.C361ET;
            default:
                return BandConstants.C361CQ;
        }
    }

    public static Map<String, Integer> createOpenCardAction(String brandCode) {
        Map<String, Integer> map = new HashMap<>();
        switch (brandCode) {
            case BandConstants.C361LIST:
                map.put(BandConstants.C361DZ, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361ET, OpenCardActionEnum.PLATFORM_ONLINE_OPENCARD.getCode());
                break;
            case BandConstants.C361DZ:
                map.put(BandConstants.C361DZ, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361ET, OpenCardActionEnum.UPDATE_ACTION.getCode());
                break;
            case BandConstants.C361ET:
                map.put(BandConstants.C361ET, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361DZ, OpenCardActionEnum.UPDATE_ACTION.getCode());
                break;
            default:
                map.put(BandConstants.C361CQ, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                break;
        }
        return map;
    }


    public static Map<String, Integer> createOpenCardActionMap(String brandCode, Integer registerType) {
        Map<String, Integer> map = new HashMap<>();
        switch (brandCode) {
            case BandConstants.C361LIST:
                map.put(BandConstants.C361DZ, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361ET, OpenCardActionEnum.PLATFORM_ONLINE_OPENCARD.getCode());
                map.put(BandConstants.C361JT, OpenCardActionEnum.UPDATE_ACTION.getCode());
                break;
            case BandConstants.C361DZ:
                map.put(BandConstants.C361DZ, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361JT, OpenCardActionEnum.UPDATE_ACTION.getCode());
                break;
            case BandConstants.C361ET:
                map.put(BandConstants.C361ET, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361JT, OpenCardActionEnum.UPDATE_ACTION.getCode());
                break;
            default:
                map.put(BandConstants.C361CQ, OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode());
                map.put(BandConstants.C361JT, OpenCardActionEnum.UPDATE_ACTION.getCode());
                break;
        }

        if (1 == registerType.intValue()) {
            map.entrySet().stream().forEach(m -> {
                if (OpenCardActionEnum.OPENAPI_ONLINE_OFFLINE_OPENCARD.getCode().intValue() == m.getValue().intValue()) {
                    m.setValue(OpenCardActionEnum.PLATFORM_ONLINE_OPENCARD.getCode());
                }
            });
        }


        return map;
    }


    public static Map<String, Integer> createOrderAction(String brandCode, Integer registerType) {
        Map<String, Integer> map = new HashMap<>();
        switch (brandCode) {
            case BandConstants.C361LIST:
                map.put(BandConstants.C361DZ, OrderActionEnum.OPENAPI_ONLINE_OFFLINE_ORDER.getCode());
                map.put(BandConstants.C361ET, OrderActionEnum.PLATFORM_ONLINE_ORDER.getCode());
                break;
            case BandConstants.C361DZ:
                map.put(BandConstants.C361DZ, OrderActionEnum.OPENAPI_ONLINE_OFFLINE_ORDER.getCode());
                break;
            case BandConstants.C361ET:
                map.put(BandConstants.C361ET, OrderActionEnum.OPENAPI_ONLINE_OFFLINE_ORDER.getCode());
                break;
            default:
                map.put(BandConstants.C361CQ, OrderActionEnum.OPENAPI_ONLINE_OFFLINE_ORDER.getCode());
                break;
        }
        if (1 == registerType.intValue()) {
            map.entrySet().stream().forEach(m -> {
                if (OrderActionEnum.OPENAPI_ONLINE_OFFLINE_ORDER.getCode().intValue() == m.getValue().intValue()) {
                    m.setValue(OrderActionEnum.PLATFORM_ONLINE_ORDER.getCode());
                }
            });
        }
        return map;
    }

}
