package com.daas.nros.openapi.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class VGOrderUsedDetailVO {
    /**
     * 订单明细单号
     */
    private String orderDetailNo;
    /**
     * 购买数量（退货时为负数）
     */
    private Integer quantity;
    /**
     * 商品编号(spuCode)
     */
    private String productNo;
    /**
     * 商品名称(spuName)
     */
    private String productName;
    /**
     * skuCode
     */
    private String skuCode;
    /**
     * 吊牌价
     */
    private BigDecimal tagPrice;
    /**
     * 成交价（成交价 = 折扣价 = 吊牌价 * 折扣率）
     */
    private BigDecimal tradeAmountDetail;
    /**
     * 折扣价
     */
    private BigDecimal discountPrice;
    /**
     * 商品折扣率（折扣价/吊牌价）
     */
    private BigDecimal rebate;
    /**
     * 规格（商品样式，存储为json格式，例如：{颜色:"001:红色",尺码 :"001:M"}）
     */
    private String specification;
    /**
     * 商品导购code，多导购以逗号分隔
     */
    private String productGuideCodes;
    /**
     * 订单服务导购ids
     */
    private String serviceGuideIds;
    /**
     * 商品导购名称
     */
    private String productGuideNames;
    /**
     * 线上服务导购提成比例(多导购)
     * 多导购以逗号分隔
     */
    private String productGuideProportion ;
    /**
     * 单商品使用积分数（不要*数量）
     * 考虑到退单需要部分退，需要放商品中
     */
    private Integer integralUsed ;
    /**
     * 赠送的积分
     */
    private Integer integralSend ;

}
