package com.daas.nros.openapi.model.vo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Data
public class VGCouponRulesRequestVO {

    private Long sysCompanyId;
    @NotBlank
    private String brandCode;
    @NotBlank
    private String coupGrpId;
    @NotBlank
    private String coupGrpName;
    private String coupName;
    private String couponName;
    private String useDesc;
    /**
     * 有效期类型：1-日期区间，2-领取后X天有效， 5 领取后X天生效 效期X天
     */
    @NotNull
    private Integer validType;
    private String validStartAt;
    private String validEndAt;
    private Integer validDay;
    /**
     * 领取X天后生效
     */
    private Integer delayDay;
    /**
     * 领取X天后有效期X天
     */
    private Integer delayValidDay;
    /**
     * 是否允许转赠（1允许转赠，0不允许转赠）
     */
    private Boolean isTransfer;
    /**
     * 转增后1核销送券，0不送券
     */
    private Boolean transferSend;
    @NotNull
    private Integer preferentialType;
    private BigDecimal coupValue;
    private BigDecimal amtLimit;
    private BigDecimal disLimit;
    private Integer maxQtyBuy;
    private String allowMoreCoup;
    private String storeLimit;
    private String proLimit;
    private String proForbid;
    private String useBrandCode;

    // 优惠券设置属性-大区，支社
    private Long sysBojunDataId;
    /**
     * 伯俊属性ID
     */
    private String propId;

    /**
     * 伯俊品牌/俱乐部ID
     */
    private String bojunBrandId;

    /**
     * 属性名称
     */
    private String propName;

    /**
     *  属性简称
     */
    private String propSimpleName;

    /**
     * 属性code
     */
    private String propCode;

    /**
     * 属性值
     */
    private String propValue;

    /**
     * 属性类型 branch支社 region 大区
     */
    private String propType;


    /**
     * 数据有效性：Y=有效；N=无效
     */
    private String propStatus;

    /**
     * 门店使用类型：1-全部适用，2-部分门店，3-部分支社，4-部分大区
     */
    private Byte applianceStoreType;

    /**
     * 渠道限制（1仅线下,2全渠道,3仅线上,4员工券,5天猫券, 6积分券,7商城私有券）',
     */
    private Byte useChannel;

    // 最大件数
    private Integer maxCommodityNum;
    
}
