package com.daas.nros.openapi.model.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * @author lijiachun
 */
@Data
public class DefCouponQueryInfo361ReqVO {

    /**
     * 品牌code
     */
    @NotEmpty
    private String brandCode;

    /**
     * 渠道标识1:门店pos 2:全渠道,3:微商城,4，线上（全渠道+微商城）
     */
    private String platform;

    /**
     * 	券定义ids，上限10个,逗号分割
     */
    private String coupoDefinitionIds;

    /**
     * 当前页码,默认第一页
     */
    private Integer pageNo = 1;

    /**
     * 每页显示条数,每页最大200条,默认10条
     */
    private Integer pageSize = 10;
}
