package com.daas.nros.openapi.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CommonOrderRequestApiVo {
    private Long sysCompanyId;//非openApi接口字段 attention!!!

    @NotNull
    private String brandCode;//		是	string	品牌id

    @NotNull
    private Integer orderFlag;//		是	string	1是订单2是退单

    private String phone;//		是	string	会员手机号

    @NotNull
    private String erpId;//		是	string	会员唯一标识(类似于主键id、会员code、costomerCode等)

    @NotNull
    private String orderNo;//		是	string	订单号

    private String cardNo;

    private String offlineCardNo;

    private String originalOrderNo;//原始订单

    private String levelCode; // 订单code

    @NotNull
    private Integer orderFrom;//		是	int	订单来源 : 1.POS(门店) 2.商城

    private BigDecimal commodityAmount;//		否	decimal	商品金额 成交总额

    private BigDecimal tradeAmount;//		否	decimal	成交金额(优惠卷+抵扣卷+打折)

    private BigDecimal preferentialAmount;//		否	decimal	优惠券优惠金额

    private BigDecimal deductibleAmount;    //	否	decimal	积分抵扣金额

    @NotNull
    private Date placeOrderTime;//		否	dateTime	下单时间

    private Date billTime ;

    private Date payTime;//		否	dateTime	支付时间

    private BigDecimal payMoney;//		否	decimal	支付金额

    private Integer usedIntegral;//		否	int	使用积分

    private Integer getIntegral;// 否 int获得积分

    private Integer productCount;//		否	int	商品数量(发货数量)

    private Date sendTime;//		否	dateTime	发货时间

    private String storeCode;//		否	string	店铺Code

    private String storeName;//		否	string	店铺名称

    private String serviceStoreSite;//  线下店铺地址

    private String guideCodes;        //否	string	店铺服务导购Code

    private String guideNames;//	否	string	店铺导购名称

    private List<CommonOrderCouponApiInfo> couponInfo;//		否	string	关联优惠券

    private List<CommonOrderApiDetail> orderDetail;//		否	string	关联订单明细

    private List<CommonOrderApiPayment> orderPayMent;//		否	string	关联支付明细

    private String buyerRemark;//		否	string	买家备注

    private String remark;//		否	string	备注

    //  微盟为服务门店
    private String sendStoreCode;

    // 商城参数 订单类型(1 整单 ，2 子单)
    private Integer orderType ;

    // 该笔订单产生的时间点(1 发货之后，2 过了有效退换货期之后，3 过了有效期退换货之后且是第一次发送的整单)
    private Integer orderBuildType;

    private String offlineGuideIds; //线下导购id集合 逗号分隔

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonOrderRequestApiVo that = (CommonOrderRequestApiVo) o;
        return sysCompanyId.equals(that.sysCompanyId) && brandCode.equals(that.brandCode) && orderNo.equals(that.orderNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sysCompanyId)&Objects.hash(brandCode)&Objects.hash(orderNo);
    }

}
