package com.daas.nros.openapi.constant;


public enum GoodsPropertiesType {

    YEAR_PRD("1", "年份"),
    SEASON_PRD("2", "季节"),
    TYPE_PRD("3", "类型"),
    BAND_PRD("4", "波段"),
    FABELEMENT("5", "面料成份"),
    CLOTHE_PRD("6", "上下装"),
    SERIES_PRD("7", "系列"),
    SUBSERIES_PRD("8", "子系列"),
    SEX_PRD("9", "性别");

    String code;
    String desc;

    GoodsPropertiesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getGoodsPropertiesDescByCode(String code){
        for(GoodsPropertiesType propertiesType : GoodsPropertiesType.values()){
            if(code.equals(propertiesType.getCode())){
                return propertiesType.getDesc();
            }
        }
        return null;
    }

}
