package com.daas.nros.openapi.api;

import com.bizvane.appletservice.models.bo.CouponEntityAndDefinitionBo;
import com.bizvane.couponfacade.models.po.CouponDefinitionPO;
import com.bizvane.couponfacade.models.vo.standard.StandardCouponUseRequestVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.openapi.model.req.VgCouponsStateReq;
import com.daas.nros.openapi.model.vo.*;

public interface VgCouponService {

    /**
     * 优惠券状态查询
     * @param requestVo
     * @return
     */
    ResponseData<VgCouponStateVo> couponState(VgCouponsStateReq requestVo);

    /**
     * 优惠券定义同步
     * @param requestVo
     * @return
     */
    ResponseData<String> couponDef(VGCouponRulesRequestVO requestVo);

    /**
     * 券实体接受
     * @param receiveCouponsRequestVo
     * @return
     */
    ResponseData<String> couponEntityAdd( ReceiveCouponsRequestVo receiveCouponsRequestVo);

    /**
     * 券状态变更(券作废)
     * @param receiveCouponsRequestVo
     * @return
     */
    ResponseData<String> couponStateChange( VGCouponStateChangeRequestVO receiveCouponsRequestVo);

    /**
     * 券冲正
     *
     * @param requestVo
     * @return
     */
    ResponseData<String> reversalCoupon(VGCouponReversalRequestVO requestVo);

    /**
     * POS券冲正
     *
     * @param requestVo
     * @return
     */
    ResponseData<String> reversalPosCoupon(VGCouponReversalRequestVO requestVo);

    /**
     * 优惠券定义查询
     *
     * @param requestVo
     * @return
     */
    ResponseData<PageInfo<CouponDefinitionPO>> getCouponDefinitions(VgCouponDefinitionsRequestVo requestVo);

    /**
     * 优惠券发放
     *
     * @param requestVo
     * @return
     */
    ResponseData<VGSendCouponsResponseVo> sendCoupon(VGSendCouponsRequestVo requestVo);


    ResponseData<PageInfo<CouponEntityAndDefinitionBo>> getJHMemberCoupons(VGCouponListRequestVO requestVO);

    /**
     * 优惠券核销
     */
    ResponseData couponUse(StandardCouponUseRequestVo requestVo);

    /**
     * 券定义和券的验证接口
     * @param vgCouponCheckVO
     * @return ResponseData
     * 2022-12-23 14:19:19
     */
    ResponseData checkCouponValid( VGCouponCheckVO vgCouponCheckVO);

}