package com.daas.nros.openapi.utils;

import cn.bizvane.openapi.client.sdk.SignatureUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

public class SignUtil {

    private static final Logger logger = LoggerFactory.getLogger(SignUtil.class);

    /**
     *  对获取数据进行页签进行验证
     * @param appkey  本地存储appkey.
     * @param appsecret  本地存储 appsecret
     * @param body  获取请求参数
     * @param request http请求
     * @return
     */
    public static boolean signVerify(String appkey,String appsecret,String body,HttpServletRequest request){
        Boolean flag=false;
        JSONObject jsonObject = JSONObject.parseObject(body);
        logger.info("签名验证数据:{}",jsonObject.toJSONString());
        Map<String, Object> jsonMap =  JSONObject.toJavaObject(jsonObject, Map.class);
        HashMap<String,String> head= HeadUtil.getHeaderInfo(request);
        String bizvane_signature=head.get("bizvane-signature");
        String bizvane_appkey=head.get("bizvane-appkey");
        String bizvane_timestamp=head.get("bizvane-timestamp");
        String bizvane_nonce=head.get("bizvane-nonce");
        jsonMap.put("bizvane-appkey",bizvane_appkey);
        jsonMap.put("bizvane-appsecret",appsecret);
        jsonMap.put("bizvane-nonce",bizvane_nonce);
        jsonMap.put("bizvane-timestamp",bizvane_timestamp);
        if(!appkey.equals(bizvane_appkey)){
            return flag;
        }
        String signatrue= SignatureUtils.sign(appsecret,jsonMap);
        if (bizvane_signature.equals(signatrue)){
            flag = true;
        }
        return  flag;
    }

}
