package com.daas.nros.openapi.utils;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.daas.nros.openapi.model.vo.VGCouponReversalPosRequestVO;
import org.apache.commons.codec.binary.Base64;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestPos {

    public static Map signToRequest(String method, String appId, String version, String appSecret) {
        String timestamp = DateUtil.getCurrentStateTime();
        Map map = new HashMap<>();
        map.put("appId", appId);
        map.put("method", method);
        map.put("timestamp", timestamp);
        map.put("version", version);
        StringBuffer param = new StringBuffer();
        try {
            param.append("appId=" + new String(Base64.encodeBase64(appId.getBytes("UTF-8"))));
            param.append("&appSecret=" + new String(Base64.encodeBase64(appSecret.getBytes("UTF-8"))));
            param.append("&version=" + new String(Base64.encodeBase64(version.getBytes("UTF-8"))));
            param.append("&method=" + new String(Base64.encodeBase64(method.getBytes("UTF-8"))));
            param.append("&timestamp=" + new String(Base64.encodeBase64(timestamp.getBytes("UTF-8"))));
            String query = param.toString();
            map.put("sign", MD5(query).toUpperCase());
            return map;
        } catch (UnsupportedEncodingException e) {
            return null;
        } catch (Exception e) {
            return null;
        }
    }

    public static String MD5(String str) {
        String r = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes("utf-8"));
            byte b[] = md.digest();
            int i;
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0)
                    i += 256;
                if (i < 16)
                    buf.append("0");
                buf.append(Integer.toHexString(i));
            }
            r = buf.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }


    /**
     * 请求线下POS
     *
     * @param url
     * @param appId
     * @param appSecret
     * @return
     */
    public static String doPost(VGCouponReversalPosRequestVO vo, String url, String appId, String appSecret) throws Exception {

        Map map = signToRequest("Burgeon.Bos.Coupon.UseCoupon", appId, "3.1", appSecret);
        map.put("param", JSON.toJSON(vo));
        String mapParams = JSONObject.toJSONString(map);

        String httpResult = RestUtils.sendRequestBuff(url + "/rest/coupon/useCoupon", mapParams, "POST");
        return httpResult;
    }

}
