/*
 * Created by jiangwenjian on 2018-07-31.
 */
package com.daas.nros.openapi.utils;

import okhttp3.*;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

/**
 * @author jiangwenjian
 * @version 0.0.1
 * @since 0.0.1 2018-07-31
 */

public class HttpClient {
    OkHttpClient okHttpClient = new OkHttpClient();
    public static final MediaType JSON = MediaType.parse("application/json; charset=utf-8");

    public HttpClient() {
    }

    public Response get(String url) throws IOException {
        Request request = (new Request.Builder()).url(url).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }

    public Response post(Request request) throws IOException {
        OkHttpClient okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(5, TimeUnit.SECONDS)
                .readTimeout(10, TimeUnit.SECONDS)
                .writeTimeout(10, TimeUnit.SECONDS)
                //设置连接池保活时间15s
                .connectionPool(new ConnectionPool(15,15, TimeUnit.SECONDS))
                .build();
        Response response = okHttpClient.newCall(request).execute();
        return response;
    }

    public Response Post(String url, String json) throws IOException {
        RequestBody body = RequestBody.create(JSON, json);
        Request request = (new Request.Builder()).url(url).post(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        if(response.isSuccessful()) {
            return response;
        } else {
            throw new IOException("Unexpected code " + response);
        }
    }

    public Response delete(String url, String json) throws IOException {
        RequestBody body = RequestBody.create(JSON, json);
        Request request = (new Request.Builder()).url(url).delete(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }

    public Response put(String url, String json) throws IOException {
        RequestBody body = RequestBody.create(JSON, json);
        Request request = (new Request.Builder()).url(url).put(body).build();
        Response response = this.okHttpClient.newCall(request).execute();
        return response;
    }
}