package com.daas.nros.openapi.utils;

import com.daas.nros.openapi.constant.BandConstants;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author sampson
 * @Date 2021-03-19 16:57
 * @Describe 静态公共方法
 */
public class DefinitionFuncImpl {


    /**
     * 判断是否是 TT TN TZ
     * @param brandCode
     * @return
     * 322 所有的接口中的俱乐部只有TW，如果传上来的是TT TN TZ 的需要转换，
     * 405 接口中传上来的TT TN TZ 写到对应的俱乐部里面，TW俱乐部的看文档部分需要双写。
     */
    public static boolean checkBrandCodeIsTWUnder(String brandCode){
        if(StringUtils.isBlank(brandCode)){
            throw new IllegalArgumentException("brandCode错误");
        }
        if( brandCode.equals(BandConstants.TT_CLUB )
                || brandCode.equals( BandConstants.TN_CLUB )
                || brandCode.equals( BandConstants.TZ_CLUB ) ){
            return true;
        }
        return false;
    }

    /**
     * 是否是MALL-CLUB
     * @param brandCode
     * @return
     * 参考 https://www.processon.com/view/link/604e23f9637689019dd9a58a
     */
    public static boolean checkBrandCodeIsMall(String brandCode){
        if (brandCode.equals(BandConstants.MALL_CLUB)) {
            return true;
        }
        return false;
    }


}
