package com.daas.nros.openapi.rpc;

import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.openapi.model.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 第三方会员通rpc
 */
@FeignClient(value = "${feign.client.openapi.name}",path = "${feign.client.openapi.path}/third")
public interface ThirdFeignRpc {

    @PostMapping(value = "/member/openCard")
    ResponseData<ThirdOpenCardRespVo> openCard(@RequestBody @Valid ThirdOpenCardReqVo requestVo);

    @PostMapping(value = "/member/memberPerfect")
    ResponseData<MemberPerfectDataResponseVO> memberPerfect(@RequestBody @Valid CommonMemberPerfectRequestVo requestApiVo);

    @PostMapping(value = "/order/addCommonOrder")
    ResponseData<String> addCommonOrder(@RequestBody @Valid CommonOrderRequestApiVo requestApiVo);

}
