package com.daas.nros.openapi.rpc;

import com.bizvane.couponfacade.models.vo.standard.StandardCouponUseRequestVo;

import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.openapi.model.vo.CommonOrderRequestApiVo;
import com.daas.nros.openapi.model.vo.IntegralAdjustYmRequestVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 内部调用会员标准开卡rpc接口
 **/
@FeignClient(value = "${feign.client.openapi.name}",path = "${feign.client.openapi.path}/common")
public interface CommonFeignRpc {

    @PostMapping(value = "/order/addCommonOrder")
    ResponseData<String> addCommonOrder(@RequestBody @Valid CommonOrderRequestApiVo requestApiVo);

    @PostMapping(value = "/integral/integralAdjust")
    ResponseData integralAdjust(@RequestBody @Valid IntegralAdjustYmRequestVO vo);

    /**
     * 券核销接口
     * @param requestVo
     * @return
     */
    @PostMapping(value = "/coupon/couponUse")
    ResponseData<String> couponUse(@RequestBody StandardCouponUseRequestVo requestVo);
}
