package com.daas.nros.openapi.model.vo.webhook;

import com.daas.nros.openapi.utils.valid.EnumStringValue;
import com.daas.nros.openapi.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class IntegralAdjustVo {

    /**
     * 品牌code
     */
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    /**
     * 变更积分数 如果是扣减 则为负数
     */
    @NotBlank(message = "变更积分数量不能为空")
    private String changeIntegral;

    /**
     * 会员卡号
     */
    private String cardNo;

    /**
     * 变更说明
     */
    private String changeRemark;

    /**
     * 店铺Code
     */
    private String storeCode;

}
