package com.daas.nros.openapi.model.vo;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class VGOrderMallRequestListVO {
    /**
     * 订单类型(1 整单 ，2 子单)
     */
    @NotNull(message = "订单类型不能为空")
    @Max(value = 2,message = "订单类型有误")
    @Min(value = 1,message = "订单类型有误")
    private Integer orderType ;

    @Valid
    @NotEmpty
    private List<VGOrderMallRequestVO> dataList ;

}
