package com.daas.nros.openapi.model.vo;

import com.daas.nros.openapi.utils.valid.EnumStringValue;
import com.daas.nros.openapi.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class VGIntegralRecordRequestVO {

    /**
     * 品牌俱乐部
     */
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    /**
     * 积分流水唯一编号(和 cardNo 二选一)
     */
    private String serialNumber;

    /**
     * 会员卡号 (和 serialNumber 二选一)
     */
    private String cardNo ;

    /**
     * 第几页
     */
    private Integer pageNo = 1;

    /**
     * 一页多少个
     */
    private Integer pageSize = 10;


    // 变更方向
    private Integer changeWay;

}
