package com.daas.nros.openapi.model.vo;

import com.daas.nros.openapi.utils.valid.EnumStringValue;
import com.daas.nros.openapi.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class VGIntegralAdjustRequestVO {

    /**
     * 品牌code
     */
    @NotBlank(message = "品牌code不能为空")
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    /**
     * 线下积分变更流水号
     */
    @NotBlank(message = "积分流水号不能为空")
    private String serialNumber;


    /**
     * 会员卡号
     */
    @NotBlank(message = "会员卡号不能为空")
    private String cardNo;

    /**
     * 变更积分数 如果是扣减 则为负数
     */
    @NotBlank(message = "变更积分数量不能为空")
    private String changeIntegral;

    /**
     * 店铺Code
     */
    @NotBlank(message = "店铺CODE不能为空")
    private String storeCode;

    /**
     * 变更时间（yyyy-MM-dd HH:mm:ss）
     */
    private String changeDate;

    /**
     * 积分来源:1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
     */
    @NotBlank(message = "积分来源不允许为空")
    private String source;

    /**
     * 变更单据 （订单号,活动任务编号等）
     */
    private String changeBills;

    /**
     * 积分调整业务场景code ：
     * 1积分过期,
     * 2保留原积分,
     * 3积分清零,
     * 4手动调整支出,
     * 5手动调整获取,
     * 6商品消费获取,
     * 7积分兑换支出,
     * 8游戏消耗支出,
     * 9开卡活动,
     * 10智能营销活动,
     * 11升级活动,
     * 12扫码领券活动,
     * 13手动领券活动,
     * 14消费活动,
     * 15签到活动,
     * 16生日活动,
     * 17完善资料任务,
     * 18微信分享任务,
     * 19消费金额任务,
     * 20消费次数任务,
     * 21邀请开卡任务,
     * 22纪念日活动,
     * 23评价奖励活动,
     * 24线下手动调整,
     * 25线下活动调整,
     * 26积分兑换券,
     * 27转盘活动,
     * 28红包膨胀活动,
     * 29砸金蛋活动,
     * 30积分商城消费积分,
     * 31积分商城返还积分,
     * 32首单开卡活动,
     * 33宝宝生日活动,
     * 34兑换有赞积分,
     * 35微商城积分扣减,
     * 36微商城积分返还,
     * -1积分补偿,
     * 37摇一摇,
     * 38储值送礼,
     * 39佣金兑换,
     * 40天猫消费积分,
     * 42调查问卷任务,
     * 100赠送,
     * 101消费,
     * 102退货,
     * 103积分调整减积分,
     * 104积分调整增积分,
     * 105积分兑换,
     * 106积分抵现,
     * 107积分抵现返还,
     * 108积分清零,
     * 109赠送退回,
     * 110其它
     */
    @NotBlank(message = "积分调整业务场景不能为空")
    private String businessWay;

    /**
     * 变更说明
     */
    private String changeRemark;


    String addinterfaceAll = "integralAdjust,积分调整,/openapi.api/request/crmService/integralAdjust";
    String addParamList="brandCode,品牌code&serialNumber,积分流水编号&erpId,会员唯一标志&changeIntegral,变更积分数&source,积分来源&storeCode,店铺code&changeBills,变更单据&changeRemark,变更说明&businessWay,积分调整业务场景";



    /**
     * 数据来源是否来之与微盟，true: 是微盟， false: 不是
     */
    private Boolean hasWm;

}
