package com.daas.nros.openapi.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class VGCouponListRequestVO {

    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotNull(message = "会员归属品牌不能为空")
    private String brandCode;
    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotBlank(message ="会员卡号不能为空" )
    private String cardNo;
    @ApiModelProperty(value = "", name = "brandCode", notes = "品牌编号")
    @NotNull(message ="优惠券状态不能为空" )
    private Byte couponStatus;
    @ApiModelProperty(value = "", name = "pageNum", notes = "分页页码")
    @NotNull(message = "分页页码不能为空")
    private Integer pageNum;
    @ApiModelProperty(value = "", name = "pageSize", notes = "分页大小")
    @NotNull(message = "分页大小不能为空")
    private Integer pageSize;
    @ApiModelProperty(value = "", name = "searchBrandCode", notes = "品牌查询")
    private String searchBrandCode;
    @ApiModelProperty(value = "", name = "sysCompanyId", notes = "集团id")
    private Long sysCompanyId;


}
