package com.daas.nros.openapi.model.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * 燕之屋 积分变动接口
 */
@Data
public class IntegralAdjustYmRequestVO {

	/**
	 * 品牌code
	 * */
	@NotEmpty
	private String brandCode;

	/**
	 * 积分变更唯一流水号
	 * */
	@NotEmpty
	private String serialNumber;

	/**
	 * 会员唯一标识(类似于主键id、会员code、costomerCode等)
	 * */
	@NotEmpty
	private String erpId;

	/**
	 * 变更积分数 如果是扣减 则为负数
	 * */
	@NotEmpty
	private String changeIntegral;

	/**
	 * 积分来源:1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他
	 * */
	private String source;

	/**
	 * 店铺Code
	 * */
	private String storeCode;

	/**
	 * 变更单据 （订单号）
	 * */
	private String changeBills;

	/**
	 * 变更说明
	 * */
	private String changeRemark;

	/**
	 * 积分调整业务场景code
	 * */
	private String businessWay;

}
