package com.daas.nros.openapi.model.vo;
/*
 * Created by JiangWenjian on 2019-11-27.
 */

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jiangwenjian
 * @version 0.0.1
 * @since 0.0.1 2019-11-27
 */
public class CouponOrderEntityApiVO implements Serializable {

    /**
     * 1.可用 2.不可用 3.不存在
     */
    private  String type;
    /**
     * 券code
     */
    private  String couponCode;
    /**
     * 券名称
     */
    private  String couponName;
    /**
     * 券类型 1现金，2折扣
     */
    private  String couponType;
    /**
     *  券面额
     */
    private BigDecimal  money;
    /**
     *  券折扣
     */
    private double discount;
    /**
     *  最低适用金额
     */
    private BigDecimal minMoney;
    /**
     *  适用券张数,1:不限制,2:限制
     */
    private int  couponSize;
    /**
     *  不限制则返回0,否则返回具体限制数值
     */
    private int  couponSizeNum;
    /**
     * 适用门店code,多个逗号隔开
     */
    private  String storeCodes;


    private Long couponDefinitionId;
    /**
     * 适用商品SKUcode,多个逗号隔开,例如:{“goodsCode”:”skuCode”,”goodsCode1”:”skuCode1” }
     */
   // private String goodsSKUCodes;
    /**
     * 不可用原因
     */
    private String reason;

    private  BigDecimal maxOffsetAmount;

    private List<String> goodsSKUCodes;

    /**
     * 允许叠加其他活动时该字段返回1，不允许和部份返回0
     * */
    private int doubleDiscountState;

    public int getDoubleDiscountState() {
        return doubleDiscountState;
    }

    public void setDoubleDiscountState(int doubleDiscountState) {
        this.doubleDiscountState = doubleDiscountState;
    }

    public List<String> getGoodsSKUCodesNot() {
        return goodsSKUCodesNot;
    }

    public void setGoodsSKUCodesNot(List<String> goodsSKUCodesNot) {
        this.goodsSKUCodesNot = goodsSKUCodesNot;
    }

    private List<String> goodsSKUCodesNot;

    public CouponOrderEntityApiVO() {}

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public void setCouponCode(String couponCode) {
        this.couponCode = couponCode;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getCouponType() {
        return couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public double getDiscount() {
        return discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public BigDecimal getMinMoney() {
        return minMoney;
    }

    public void setMinMoney(BigDecimal minMoney) {
        this.minMoney = minMoney;
    }

    public int getCouponSize() {
        return couponSize;
    }

    public void setCouponSize(int couponSize) {
        this.couponSize = couponSize;
    }

    public int getCouponSizeNum() {
        return couponSizeNum;
    }

    public void setCouponSizeNum(int couponSizeNum) {
        this.couponSizeNum = couponSizeNum;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public BigDecimal getMaxOffsetAmount() {
        return maxOffsetAmount;
    }

    public void setMaxOffsetAmount(BigDecimal maxOffsetAmount) {
        this.maxOffsetAmount = maxOffsetAmount;
    }

    public String getStoreCodes() {
        return storeCodes;
    }

    public void setStoreCodes(String storeCodes) {
        this.storeCodes = storeCodes;
    }

    public List<String> getGoodsSKUCodes() {
        return goodsSKUCodes;
    }

    public void setGoodsSKUCodes(List<String> goodsSKUCodes) {
        this.goodsSKUCodes = goodsSKUCodes;
    }

    public Long getCouponDefinitionId() {
        return couponDefinitionId;
    }

    public void setCouponDefinitionId(Long couponDefinitionId) {
        this.couponDefinitionId = couponDefinitionId;
    }
}
