package com.daas.nros.openapi.model.vo;


import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lijiachun
 * @version 0.0.1
 * @since 0.0.1 2020-02-24
 */
@Data
@Builder
public class CouponEntityApiUrVO implements Serializable {

    /**
     * 券code
     */
    private  String couponCode;
    /**
     * 券名称
     */
    private  String couponName;
    /**
     * 券类型 1现金，2折扣，3礼品
     */
    private  Byte couponType;
    /**
     *  券面额
     */
    private BigDecimal  money;
    /**
     *  券折扣
     */
    private BigDecimal discount;
    /**
     * 有效期开始时间
     */
    private Date validDateStart;
    /**
     * 有效期结束时间
     */
    private Date validDateEnd;

    /**
     * 只读. 适用门店类型：1-全部适用，2-部分适用. appliance_store_type
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "适用门店类型：1-全部适用，2-部分适用", name = "applianceStoreType", required = false, example = "")
    private Byte applianceStoreType;

    /**
     * 只读. 门店白名单. store_whitelist
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "门店白名单", name = "storeWhitelist", required = false, example = "")
    private String storeWhitelist;

    /**
     * 只读. 门店黑名单. store_blacklist
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "门店黑名单", name = "storeBlacklist", required = false, example = "")
    private String storeBlacklist;

    /**
     * 只读. 是否允许叠加（1是，0否）. is_superposition
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "是否允许叠加券（1是，0否）", name = "isSuperposition", required = false, example = "")
    private Boolean isSuperposition;

    /**
     * 只读. 活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用. activity_superposition_type
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用", name = "activitySuperpositionType", required = false, example = "")
    private Byte activitySuperpositionType;

    /**
     * 只读. 活动叠加白名单. activity_superposition_white_list
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "活动叠加白名单", name = "activitySuperpositionWhiteList", required = false, example = "")
    private String activitySuperpositionWhiteList;
    /**
     * 只读. 活动叠加黑名单. activity_superposition_black_list
     * @mbg.generated  2020-03-17 15:29:44
     */
    @io.swagger.annotations.ApiModelProperty(value = "活动叠加黑名单", name = "activitySuperpositionBlackList", required = false, example = "")
    private String activitySuperpositionBlackList;
}
