package com.daas.nros.openapi.model.vo;

import com.daas.nros.openapi.utils.valid.EnumStringValue;
import com.daas.nros.openapi.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

@Data
public class ChangeCardLevelRequestVo {

    @NotEmpty
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;

    @NotEmpty
    private String cardNo;

    @NotEmpty
    private String oldLevelCode;

    @NotEmpty
    private String newLevelCode;

    private String detail;

    @Override
    public String toString() {
        return "ChangeCardLevelRequestVo{" +
                "brandCode='" + brandCode + '\'' +
                ", cardNo='" + cardNo + '\'' +
                ", oldLevelCode='" + oldLevelCode + '\'' +
                ", newLevelCode='" + newLevelCode + '\'' +
                ", detail='" + detail + '\'' +
                '}';
    }
}
