/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.openapi.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public class MapResult {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Integer errcode;
    private String errmsg;
    private Object data;

    public static MapResult build(Integer errcode, String msg, Object data) {
        return new MapResult(errcode, msg, data);
    }

    public static MapResult ok(Object data) {
        return new MapResult(data);
    }

    public static MapResult ok() {
        return new MapResult(null);
    }

    public MapResult() {
    }

    public static MapResult build(Integer status, String msg) {
        return new MapResult(status, msg, null);
    }

    public MapResult(Integer errcode, String msg, Object data) {
        this.errcode = errcode;
        this.errmsg = this.errmsg;
        this.data = data;
    }

    public MapResult(Object data) {
        this.errcode = 200;
        this.errmsg = "OK";
        this.data = data;
    }

    public Integer getErrcode() {
        return this.errcode;
    }

    public void setErrcode(Integer errcode) {
        this.errcode = errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static MapResult formatToPojo(String jsonData, Class<?> clazz) {
        try {
            if (clazz == null) {
                return (MapResult)MAPPER.readValue(jsonData, MapResult.class);
            }
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (clazz != null) {
                if (data.isObject()) {
                    obj = MAPPER.readValue(data.traverse(), clazz);
                } else if (data.isTextual()) {
                    obj = MAPPER.readValue(data.asText(), clazz);
                }
            }
            return MapResult.build(jsonNode.get("status").intValue(), jsonNode.get("msg").asText(), obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static MapResult format(String json) {
        try {
            return (MapResult)MAPPER.readValue(json, MapResult.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MapResult formatToList(String jsonData, Class<?> clazz) {
        try {
            JsonNode jsonNode = MAPPER.readTree(jsonData);
            JsonNode data = jsonNode.get("data");
            Object obj = null;
            if (data.isArray() && data.size() > 0) {
                obj = MAPPER.readValue(data.traverse(), (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
            }
            return MapResult.build(jsonNode.get("status").intValue(), jsonNode.get("msg").asText(), obj);
        }
        catch (Exception e) {
            return null;
        }
    }
}

