/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.openapi.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    public static String ymdhms = "yyyy-MM-dd HH:mm:ss";
    public static String ymdhmsS = "yyyy-MM-dd HH:mm:ss SSS";
    public static String ymd = "yyyy-MM-dd";
    private static String year = "yyyy";
    private static String month = "MM";
    private static String day = "dd";
    private static String hour = "HH";
    public static long DATEMM = 86400L;

    public static String getCurrentStateTime() {
        return new SimpleDateFormat(ymdhms).format(new Date());
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat(ymdhms).format(new Date());
    }

    public static String getStrDateByDay(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getStrDateByMonth(String backMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, Integer.parseInt("-" + backMonth));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static int differentDaysByMillisecond(String date1String, String date2String) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = format.parse(date1String);
            date2 = format.parse(date2String);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int days = 0;
        if (date1 == null || date2 == null) {
            return days;
        }
        days = (int)((date2.getTime() - date1.getTime()) / 86400000L) + 1;
        return days;
    }

    public static Date getSpecifiedDayBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return c.getTime();
    }

    public static String getSpecifiedDayBeforeString(String sDate, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        c.setTime(formatDate);
        int day = c.get(5);
        c.set(5, day - before);
        return format.format(c.getTime());
    }

    public static String getCurrentYear() {
        return new SimpleDateFormat(year).format(new Date());
    }

    public static String getCurrentMonth() {
        return new SimpleDateFormat(month).format(new Date());
    }

    public static String getCurrentDay() {
        return new SimpleDateFormat(day).format(new Date());
    }

    public static String getCurrentHour() {
        return new SimpleDateFormat(hour).format(new Date());
    }

    public static String getCurrentymd() {
        return new SimpleDateFormat(ymd).format(new Date());
    }

    public static String getCurrentymdhmsS() {
        return new SimpleDateFormat(ymdhmsS).format(new Date());
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long getCurrentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getTimeNumberToday() {
        Date date = new Date();
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMdd.parse(str);
            return date.getTime() / 1000L;
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    public static String getTodateString() {
        String str = new SimpleDateFormat("yyyyMMdd").format(new Date());
        return str;
    }

    public static Date getYesterDayZeroHour(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, amount);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getStartDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getEndDateOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return cal.getTime();
    }

    public static String longToString(long date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = new Date(date * 1000L);
        String sDateTime = sdf.format(dt2);
        return sDateTime;
    }

    public static Date getTodayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return cal.getTime();
    }

    public static Date getYesterDay24Hour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 7);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 2);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static String givedTimeToBefer(String givedTime, long interval, String format_Date_Sign) {
        String tomorrow = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format_Date_Sign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current - interval * 1000L;
            Date date = new Date(beforeOrAfter);
            tomorrow = new SimpleDateFormat(format_Date_Sign).format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tomorrow;
    }

    public static long stringToLong(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = null;
        long lTime = 0L;
        try {
            dt2 = sdf.parse(date);
            lTime = dt2.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return lTime;
    }

    public static Map<String, String> getTwoDay(String endTime, String beginTime, boolean isEndTime) {
        Map<String, String> result = new HashMap<String, String>();
        if (endTime == null || "".equals(endTime) || beginTime == null || "".equals(beginTime)) {
            return null;
        }
        try {
            SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            long day = (date.getTime() - mydate.getTime()) / 86400000L;
            result = DateUtil.getDate(endTime, Integer.parseInt(day + ""), isEndTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Integer getTwoDayInterval(String endTime, String beginTime, boolean isEndTime) {
        if (endTime == null || "".equals(endTime) || beginTime == null || "".equals(beginTime)) {
            return 0;
        }
        long day = 0L;
        try {
            SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        if (isEndTime) {
            return Integer.parseInt(day + "") + 1;
        }
        return Integer.parseInt(day + "");
    }

    public static Map<String, String> getDate(String endTime, Integer interval, boolean isEndTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((interval == 0 || isEndTime) && isEndTime) {
            result.put(endTime, endTime);
        }
        if (interval > 0) {
            int begin;
            for (int i = begin = 0; i < interval; ++i) {
                endTime = DateUtil.givedTimeToBefer(endTime, DATEMM, ymd);
                result.put(endTime, endTime);
            }
        }
        return result;
    }

    public static List<Long> getDatesBetweenTwoDate(String beginDate, String endDate) throws ParseException {
        SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
        Date bDate = ymdSDF.parse(beginDate);
        Date eDate = ymdSDF.parse(endDate);
        ArrayList<Long> lDate = new ArrayList<Long>();
        lDate.add(bDate.getTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(bDate);
        boolean bContinue = true;
        while (bContinue) {
            cal.add(5, 1);
            if (!eDate.after(cal.getTime())) break;
            lDate.add(cal.getTime().getTime());
        }
        lDate.add(eDate.getTime());
        return lDate;
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static String stringToFormat(String date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate, String pattern) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String interceptFormat(String strDate, String originPattern, String newPattern) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(newPattern);
        return df.format(DateUtil.stringToDate(strDate, originPattern));
    }

    public static String interceptFormat(String strDate) {
        if (StringUtils.isEmpty((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(ymdhms);
        return df.format(DateUtil.stringToDate(strDate, ymd));
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return (int)(time / 86400000L);
    }

    public static Long getIntervalMinutes(Date date, Date otherDate) {
        long time = Math.abs(date.getTime() - otherDate.getTime());
        return time == 0L ? 0L : time / 60000L;
    }

    public static Date truncate(Date date, int field) {
        return DateUtils.truncate((Date)date, (int)field);
    }

    public int getDayOfMonth() {
        Calendar aCalendar = Calendar.getInstance(Locale.CHINA);
        int day = aCalendar.getActualMaximum(5);
        return day;
    }

    public static String getNow(String format) {
        return DateUtil.format(new Date(), format);
    }

    public static String getBirthFirst(String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            year = "0";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-12-31";
    }

    public static String getBirthLast(String year) {
        if (StringUtils.isBlank((CharSequence)year)) {
            year = "100";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return String.valueOf(Integer.parseInt(format.format(new Date())) - Integer.valueOf(year)) + "-01-01";
    }

    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCronExpression(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return DateUtil.formatDateByPattern(date, dateFormat);
    }

    public static Date getZeroTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static boolean isValidDate(String date) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat(ymdhms);
        try {
            format.setLenient(false);
            format.parse(date);
        }
        catch (Exception e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static boolean isValidDateBi(String date) {
        boolean convertSuccess = true;
        if (StringUtils.isBlank((CharSequence)date)) {
            return convertSuccess;
        }
        SimpleDateFormat format = new SimpleDateFormat(ymd);
        try {
            format.setLenient(false);
            format.parse(date);
        }
        catch (Exception e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static String transformDateToStandard(Object date, int type) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(ymdhms);
            if (date instanceof Date) {
                return format.format(date);
            }
            format.parse(date.toString());
            return date.toString();
        }
        catch (Exception e) {
            if (type == 1) {
                return DateUtil.getCurrentStateTime();
            }
            return null;
        }
    }

    public static Date transformDateByStr(String dateTime) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(ymdhms);
            return format.parse(dateTime);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date transformDateNullByStr(String dateTime) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(ymdhms);
            return format.parse(dateTime);
        }
        catch (Exception e) {
            return null;
        }
    }
}

