package com.daas.nros.openapi.utils.valid;


import com.daas.nros.openapi.constant.BandConstants;

/**
 * @Author sampson
 * @Date 2021-02-07 10:34
 * @Describe
 */
public enum StringBrandCode {

    jh( BandConstants.JH_CLUB ),
    vg( BandConstants.VG_CLUB ),
    tw( BandConstants.TW_CLUB ),
    tt( BandConstants.TT_CLUB ),
    tn( BandConstants.TN_CLUB ),
    tz( BandConstants.TZ_CLUB ),
    tf( BandConstants.TF_CLUB ),
    mall( BandConstants.MALL_CLUB ),
    yj( BandConstants.YJ_CLUB ),
    nomal( "nomal" );

    private String value;

    StringBrandCode(String value) {
        this.value = value;
    }

    // 为了使注解校验器能生效，必须有这个方法
    public static StringBrandCode toEnum(String value) {
        switch (value) {
            case BandConstants.JH_CLUB:
                return StringBrandCode.jh;
            case BandConstants.VG_CLUB:
                return StringBrandCode.vg;
            case BandConstants.TW_CLUB:
                return StringBrandCode.tw;
            case BandConstants.TT_CLUB:
                return StringBrandCode.tt;
            case BandConstants.TN_CLUB:
                return StringBrandCode.tn;
            case BandConstants.TZ_CLUB:
                return StringBrandCode.tz;
            case BandConstants.TF_CLUB:
                return StringBrandCode.tf;
            case BandConstants.MALL_CLUB:
                return StringBrandCode.mall;
            case BandConstants.YJ_CLUB:
                return StringBrandCode.yj;
            default:
                return StringBrandCode.nomal;
        }
    }

}
