package com.daas.nros.openapi.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 *  created by ypf on 2019/5/12
 * */
public class DateTools {

    public static String ymd = "yyyy-MM-dd";
    public SimpleDateFormat sdf = new SimpleDateFormat(ymd);

    /**
     * 返回两个日期之间所有日期的集合
     * 不包括开始时间
     * 包括结束时间
     * */
    public List<String> getBetweenDates(Date start, Date end) {
        List<String> result = new ArrayList<>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(Calendar.DAY_OF_YEAR, 1);

        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(sdf.format(tempStart.getTime()));
            tempStart.add(Calendar.DAY_OF_YEAR, 1);
        }
        return result;
    }

    /**
     *获得昨天的日期
     */
    public Date getYesterdayDate(){
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE,-1);
        Date time = calendar.getTime();
        return time;
    }

    /**
     * 得到本月之前的12个月
     * (不包括本月)
     * 格式:2018-02
     * */
    public String[] getPreMonth(Integer monthNum){
        String[] months = new String[monthNum];
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.MONTH, cal.get(Calendar.MONTH));
        for(int i = 0 ; i < monthNum ; i++){
            String month = cal.get(Calendar.MONTH)+"";
            if(month.length() == 1){
                month = "0" + month;
            }
            String year = cal.get(Calendar.YEAR) + "-" + month;
            if(year.substring(5).equals("00")){
                Integer yearNum = Integer.parseInt(year.substring(0,4)) - 1;
                year = yearNum + "-12";
            }
            months[monthNum - 1 - i] = year;
            cal.set(Calendar.MONTH, cal.get(Calendar.MONTH)-1);
        }
        return months;
    }

    /**
     * 得到本月之前12-24个月的任务
     * */
    public List<String> getPreDoubleTwtlveMonth(){
        String[] preTwentyFourMonth = getPreMonth(24);
        List<String> preTwentyFourMonthList = new ArrayList<>();
        for(String timeString:preTwentyFourMonth){
            preTwentyFourMonthList.add(timeString);
        }
        String[] preTwelveMonth = getPreMonth(12);
        List<String> preTwelveMonthList = new ArrayList<>();
        for(String timeString: preTwelveMonth){
            preTwelveMonthList.add(timeString);
        }
        preTwentyFourMonthList.removeAll(preTwelveMonthList);
        return preTwentyFourMonthList;
    }

    /**
     * 得到本周之前的12周List
     * index 不是指定参数则返回前12个月的
     * index 是指定参数则返回12-24个月的List  ========betweenTwelveAndTwentyFour
     * */
    public List<String> getPreWeek(String index){
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(Calendar.YEAR);
        int weekOfYear = calendar.get(Calendar.WEEK_OF_YEAR);

        List<String> weekList = new ArrayList<>();
        String weekString = "";
        for(int i = 0; i < 12 ; i++){
            weekOfYear = weekOfYear -1;
            if(weekOfYear == 0){
                //得到上一年的最后一周
                year -= 1;
                String temp = year + "-" + "12" + "-30";
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date date = format.parse(temp);
                    calendar.setFirstDayOfWeek(Calendar.MONDAY);
                    calendar.setTime(date);
                    weekOfYear = calendar.get(Calendar.WEEK_OF_YEAR);
                } catch (ParseException e) {

                }
            }
            String weekOfYearString = weekOfYear + "";
            if(weekOfYearString.length() ==1 ){
                weekOfYearString = "0" + weekOfYearString;
            }
            String yearWeek = year+"-" + weekOfYearString;
            weekList.add(yearWeek);
        }
        if("betweenTwelveAndTwentyFour".equals(index)){
            weekList.clear();
            for(int i=0;i<12;i++){
                weekOfYear = weekOfYear -1;
                if(weekOfYear == 0){
                    //得到上一年的最后一周
                    year -= 1;
                    String temp = year+"-"+"12"+"-30";
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = format.parse(temp);
                        calendar.setFirstDayOfWeek(Calendar.MONDAY);
                        calendar.setTime(date);
                        weekOfYear = calendar.get(Calendar.WEEK_OF_YEAR);
                    } catch (ParseException e) {

                    }
                }
                String weekOfYearString = weekOfYear + "";
                if(weekOfYearString.length() == 1){
                    weekOfYearString = "0" + weekOfYearString;
                }
                String yearWeek = year + "-" + weekOfYearString;
                weekList.add(yearWeek);
            }
            Collections.reverse(weekList);
            return weekList;
        }
        Collections.reverse(weekList);
        return weekList;
    }

    /**
     * 得到向前index天所在周的最后一天(无时分秒)
     * */
    public Date getLastIndexDayWeek(int index){
        Date lastSevenDay = getSpecifiedDayBefore(new Date(),index);
        return  getLastDayOfWeek(lastSevenDay);
    }

    /**
     * 获得指定日期所在的自然周的最后一天，即周日
     *
     * @param date
     * @return
     */
    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(Calendar.MONDAY);
        c.setTime(date);
        c.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
        date = c.getTime();
        return date;
    }

    /**
     * 获得指定日期所在的自然周的第一天，即周一
     *
     * @param date 日期
     * @return 自然周的第一天
     */
    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(Calendar.MONDAY);
        c.setTime(date);
        c.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        date = c.getTime();
        return date;
    }

    /**
     * 可以获取入参数时间后退N天的日期
     *
     */
    public static Date getSpecifiedDayBefore(Date date, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = format.format(date);
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        } catch (ParseException e) {

        }
        c.setTime(formatDate);
        int day = c.get(Calendar.DATE);
        c.set(Calendar.DATE, day - before);
        return c.getTime();
    }

    /**
     * 可以获取入参数时间后退N天的日期
     *
     *  @param sDate
     *  param before
     * @return String
     */
    public static String getSpecifiedDayBeforeString(String sDate, int before) {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date formatDate = null;
        try {
            formatDate = format.parse(sDate);
        } catch (ParseException e) {

        }
        c.setTime(formatDate);
        int day = c.get(Calendar.DATE);
        c.set(Calendar.DATE, day - before);
        return format.format(c.getTime());
    }

}
