package com.daas.nros.openapi.model.vo;

import com.daas.nros.openapi.annotation.DateStyleBi;
import com.daas.nros.openapi.utils.valid.EnumStringValue;
import com.daas.nros.openapi.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

@Data
public class JhStaffSyncRequestVo {

    private int sysCompanyId;

    @NotEmpty
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    /**
     * 员工code
     */
    @NotEmpty
    private String staffCode;

    /**
     * 员工姓名
     */
    private String staffName;

    /**
     * 线下店铺code
     */
    @NotEmpty
    private String storeCode;

    /**
     * 线下店铺姓名
     */
    private String storeName;

    /**
     * 国家区号默认+86
     */
    private String countryCode;

    /**
     * 手机号
     */
    @NotEmpty
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 性别 1.女 2.男 3.未知
     */
    private String sex;

    /**
     * 生日：yyyy-MM-dd
     */
    @DateStyleBi
    private String birthday;

    /**
     * 职务
     */
    private String position;

    /**
     * 状态 0.禁用 1.启用
     */
    private Integer status;
    /**
     * 入职时间
     */
    private String onDate;
    /**
     * 离职时间
     */
    private String offDate;
    /**
     * 更新时间
     */
    private String offlineUpdateDate;
    /**
     * 员工id
     */
    @NotBlank(message = "导购id不允许为空")
    private String staffId;
    String businessId;
    String hashCode;

}
